/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.ShellLimitType;
import oracle.cluster.verification.ShellResourceType;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskShellLimits {
    private String m_cmd = "ulimit";
    private String m_hardLimitFlag = "-H";
    private String m_softLimitFlag = "-S";
    private String m_descriptorFlag = "-n";
    private String m_maxProcFlag = "-u";

    public static boolean isLimitFixable(ShellResourceType resourceType, ShellLimitType limitType) {
        return true;
    }

    public String getSoftMaxProcLimitCommand() {
        return this.m_cmd + " " + this.m_softLimitFlag + " " + this.m_maxProcFlag;
    }

    public String getHardMaxProcLimitCommand() {
        return this.m_cmd + " " + this.m_hardLimitFlag + " " + this.m_maxProcFlag;
    }

    public String getSoftMaxDescriptorLimitCommand() {
        return this.m_cmd + " " + this.m_softLimitFlag + " " + this.m_descriptorFlag;
    }

    public String getHardMaxDescriptorLimitCommand() {
        return this.m_cmd + " " + this.m_hardLimitFlag + " " + this.m_descriptorFlag;
    }

    public double getHardDescriptorLimit(String cmdOutput) {
        return this.getLimit(cmdOutput);
    }

    public double getSoftDescriptorLimit(String cmdOutput) {
        return this.getLimit(cmdOutput);
    }

    public double getHardMaxProcLimit(String cmdOutput) {
        return this.getLimit(cmdOutput);
    }

    public double getSoftMaxProcLimit(String cmdOutput) {
        return this.getLimit(cmdOutput);
    }

    private double getLimit(String cmdOutput) {
        if ("unlimited".equals(cmdOutput)) {
            return Double.MAX_VALUE;
        }
        return VerificationUtil.parseStringToNumber(cmdOutput);
    }
}

